% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/LogtVaRPlot2DCL.R
\name{LogtVaRPlot2DCL}
\alias{LogtVaRPlot2DCL}
\title{Plots log-t VaR against confidence level}
\usage{
LogtVaRPlot2DCL(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 5
 or 6. In case there 5 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 investment Size of investment

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a scalar}
}
\description{
Plots the VaR of a portfolio against confidence level assuming that geometric
 returns are Student-t distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR against confidene level given geometric return data
   data <- runif(5, min = 0, max = .2)
   LogtVaRPlot2DCL(returns = data, investment = 5, df = 6, cl = seq(.85,.99,.01), hp = 60)

   # Computes VaR against confidence level given mean and standard deviation of return data
   LogtVaRPlot2DCL(mu = .012, sigma = .03, investment = 5, df = 6, cl = seq(.85,.99,.01), hp = 40)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

