% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/DefaultRiskyBondVaR.R
\name{DefaultRiskyBondVaR}
\alias{DefaultRiskyBondVaR}
\title{VaR for default risky bond portfolio}
\usage{
DefaultRiskyBondVaR(r, rf, coupon, sigma, amount.invested, recovery.rate, p,
  number.trials, hp, cl)
}
\arguments{
\item{r}{Spot (interest) rate, assumed to be flat}

\item{rf}{Risk-free rate}

\item{coupon}{Coupon rate}

\item{sigma}{Variance}

\item{amount.invested}{Amount Invested}

\item{recovery.rate}{Recovery rate}

\item{p}{Probability of default}

\item{number.trials}{Number of trials}

\item{hp}{Holding period}

\item{cl}{Confidence level}
}
\value{
Monte Carlo VaR
}
\description{
Generates Monte Carlo VaR for default risky bond portfolio in Chapter 6.4
}
\examples{
# VaR for default risky bond portfolio for given parameters
   DefaultRiskyBondVaR(.01, .01, .1, .01, 1, .1, .2, 100, 100, .95)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

