% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariateAMHCopula.R
\name{bivariateAMH}
\alias{bivariateAMH}
\alias{cBivariateAMH}
\alias{cdBivariateAMH}
\alias{crBivariateAMH}
\title{Bivariate Ali-Mikhail-Haq Copula}
\usage{
cBivariateAMH(u1, u2, dependencyParameter, ...)

cdBivariateAMH(u1, u2, dependencyParameter, ...)

crBivariateAMH(numberSimulations = 10000, seed = 42, dependencyParameter)
}
\arguments{
\item{u1, u2}{points at which to evaluate the copula.}

\item{dependencyParameter}{correlation parameter.}

\item{...}{other parameters.}

\item{numberSimulations}{Number of simulations.}

\item{seed}{Simulation seed, 42 by default.}
}
\value{
Function :
  \itemize{
    \item \code{\link{cBivariateAMH}}  returns the value of the copula.
    \item \code{\link{cdBivariateAMH}}  returns the value of the density copula.
    \item \code{\link{crBivariateAMH}}  returns simulated values of the copula.
  }
}
\description{
Computes CDF, PDF and simulations of of the bivariate Ali-Mikhail-Haq
copula.
}
\details{
The bivariate Ali-Mikhail-Haq copula has CDF :
}
\examples{
cBivariateAMH(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

cdBivariateAMH(u1 = .76, u2 = 0.4, dependencyParameter = 0.4)

crBivariateAMH(numberSimulations = 10, seed = 42, dependencyParameter = 0.2)

}
