% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pois.R
\name{Pois}
\alias{Pois}
\alias{expValPois}
\alias{varPois}
\alias{expValTruncPois}
\alias{TVatRPois}
\alias{mgfPois}
\alias{pgfPois}
\title{Poisson Distribution}
\usage{
expValPois(lambda)

varPois(lambda)

expValTruncPois(d, lambda, k0, less.than.d = TRUE)

TVatRPois(kap, lambda, k0)

mgfPois(t, lambda)

pgfPois(t, lambda)
}
\arguments{
\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}

\item{d}{cut-off value.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
  \itemize{
    \item \code{\link{expValPois}}  gives the expected value.
    \item \code{\link{varPois}}  gives the variance.
    \item \code{\link{expValTruncPois}}  gives the truncated mean.
    \item \code{\link{TVatRPois}}  gives the Tail Value-at-Risk.
    \item \code{\link{mgfPois}}  gives the moment generating function (MGF).
    \item \code{\link{pgfPois}}  gives the probability generating function (PGF).
  }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Poisson distribution with rate parameter \eqn{\lambda}{lambda}.
}
\details{
The Poisson distribution with rate parameter \eqn{\lambda}{lam}
has probability mass function :
  \deqn{Pr(X = k) = \frac{\lambda^k \textrm{e}^{-\lambda}}{k!}}{Pr(X = k) = (lam^k e^(-lam)) / k!}
for \eqn{k = 0, 1, 2, \dots}{k = 0, 1, 2, ...}, and \eqn{\lambda > 0}{lam > 0}
}
\examples{
expValPois(lambda = 3)

varPois(lambda = 3)

expValTruncPois(d = 0, lambda = 2, k0 = 2E2, less.than.d = FALSE)
expValTruncPois(d = 2, lambda = 2, k0 = 2E2, less.than.d = TRUE)

TVatRPois(kap = 0.8, lambda = 3, k0 = 2E2)

mgfPois(t = 1, lambda = 3)

pgfPois(t = 1, lambda = 3)

}
