% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompPois.R
\name{CompPois}
\alias{CompPois}
\alias{pCompPois}
\alias{expValCompPois}
\alias{varCompPois}
\alias{VatRCompPois}
\alias{TVatRCompPois}
\title{Compound Poisson Distribution}
\usage{
pCompPois(
  x,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

expValCompPois(
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

varCompPois(
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  distr_severity = "Gamma"
)

VatRCompPois(
  kap,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  k0,
  distr_severity = "Gamma"
)

TVatRCompPois(
  kap,
  lambda,
  shape,
  rate = 1/scale,
  scale = 1/rate,
  vark,
  k0,
  distr_severity = "Gamma"
)
}
\arguments{
\item{x}{vector of quantiles}

\item{lambda}{Rate parameter \eqn{\lambda}{lambda}.}

\item{shape}{shape parameter \eqn{\alpha}{alpha}, must be positive.}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{k0}{point up to which to sum the distribution for the approximation.}

\item{distr_severity}{Choice of severity distribution.
\itemize{
 \item{"gamma"} (default)
 \item{"lognormal"} only for the expected value and variance.
}}

\item{kap}{probability.}

\item{vark}{Value-at-Risk (VaR) calculated at the given probability kap.}
}
\value{
Function :
  \itemize{
    \item \code{\link{pCompPois}}  gives the cumulative density function.
    \item \code{\link{expValCompPois}}  gives the expected value.
    \item \code{\link{varCompPois}}  gives the variance.
    \item \code{\link{TVatRCompPois}}  gives the Tail Value-at-Risk.
    \item \code{\link{VatRCompPois}}  gives the Value-at-Risk.
  }
Returned values are approximations for the cumulative density function,
TVaR, and VaR.
}
\description{
Computes various risk measures (mean, variance, Value-at-Risk (VaR),
and Tail Value-at-Risk (TVaR)) for the compound Poisson distribution.
}
\details{
The compound Poisson distribution with parameters ... has density ....
}
\examples{
pCompPois(x = 2, lambda = 2, shape = log(1000) - 0.405,
          rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

expValCompPois(lambda = 2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

varCompPois(lambda = 2, shape = log(1000) - 0.405, rate = 0.9^2,
          distr_severity = "Lognormale")

VatRCompPois(kap = 0.9, lambda = 2, shape = log(1000) - 0.405,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")

vark_calc <- VatRCompPois(kap = 0.9, lambda = 2, shape = 0.59,
            rate = 0.9^2, k0 = 1E2, distr_severity = "Gamma")
TVatRCompPois(kap = 0.9, lambda = 2, shape = 0.59, rate = 0.9^2,
            vark = vark_calc, k0 = 1E2, distr_severity = "Gamma")

}
