#' @title
#' Vectorised Computation of P-Values and Their Supports for Several Discrete
#' Statistical Tests
#'
#' @name DiscreteTests-package
#'
#' @description
#' This package provides vectorised functions for computing p-values of various
#' discrete statistical tests. Exact and approximate computation methods are
#' provided. For exact p-values, several procedures of determining two-sided
#' p-values are included.
#'
#' Additionally, these functions are capable of returning the discrete p-value
#' supports, i.e. all observable p-values under a null hypothesis. These
#' supports can be used for multiple testing procedures in the
#' [`DiscreteFDR`][DiscreteFDR::DiscreteFDR-package] and
#' [`FDX`][FDX::FDX-package] packages.
#'
#' @references
#' Fisher, R. A. (1935). The logic of inductive inference.
#'   *Journal of the Royal Statistical Society Series A*, **98**, pp.
#'   39–54. \doi{10.2307/2342435}
#'
#' Agresti, A. (2002). *Categorical data analysis* (2nd ed.). New York: John
#'   Wiley & Sons. \doi{10.1002/0471249688}
#'
#' Blaker, H. (2000) Confidence curves and improved exact confidence intervals
#'   for discrete distributions. *Canadian Journal of Statistics*,
#'   **28**(4), pp. 783-798. \doi{10.2307/3315916}
#'
#' Hirji, K. F. (2006). *Exact analysis of discrete data*. New York: Chapman
#'   and Hall/CRC. pp. 55-83. \doi{10.1201/9781420036190}
#'
"_PACKAGE"

## usethis namespace: start
#' @importFrom lifecycle deprecated
## usethis namespace: end
NULL
