% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/di_iterate_sql.R
\name{di_calc_sql}
\alias{di_calc_sql}
\title{Generate SQL code that calculates disproportionate impact using multiple methods for a specified table.}
\usage{
di_calc_sql(
  db_table_name,
  success_var,
  group_var,
  cohort_var = "",
  weight_var = 1,
  ppg_reference_group = "overall",
  min_moe = 0.03,
  use_prop_in_moe = FALSE,
  prop_sub_0 = 0.5,
  prop_sub_1 = 0.5,
  di_prop_index_cutoff = 0.8,
  di_80_index_cutoff = 0.8,
  di_80_index_reference_group = "hpg",
  before_with_statement = "",
  after_with_statement = "",
  end_of_select_statement = "",
  where_statement = "",
  select_statement_add = ""
)
}
\arguments{
\item{db_table_name}{A character value specifying a database table name.}

\item{success_var}{A character value specifying the success variable name.}

\item{group_var}{A character value specifying the group (disaggregation) variable name.}

\item{cohort_var}{(Optional) A character value specifying the cohort variable.  If not specified, then a single cohort is assumed (defaults to an empty string, \code{''}).}

\item{weight_var}{(Optional) A character variable specifying the weight variable if the input data set is summarized (i.e.,  the the success variables specified in \code{success_vars} contain count of successes).  Weight here corresponds to the denominator when calculating the success rate.  Defaults to a numeric \code{1} which treats each row as an individual.}

\item{ppg_reference_group}{Either \code{'overall'}, \code{'hpg'}, \code{'all but current'}, or a character value specifying a group from \code{group_var} to be used as the reference group for comparison using the percentage point gap method.}

\item{min_moe}{The minimum margin of error to be used in the PPG calculation; see \link[DisImpact]{di_ppg}.}

\item{use_prop_in_moe}{(\code{TRUE} or \code{FALSE}) Whether the estimated proportions should be used in the margin of error calculation by the PPG; see \link[DisImpact]{di_ppg}.}

\item{prop_sub_0}{Default is 0.50; see \link[DisImpact]{di_ppg}.}

\item{prop_sub_1}{Default is 0.50; see \link[DisImpact]{di_ppg}.}

\item{di_prop_index_cutoff}{Threshold used for determining disproportionate impact using the proportionality index; see \link[DisImpact]{di_prop_index}; defaults to 0.80.}

\item{di_80_index_cutoff}{Threshold used for determining disproportionate impact using the 80\% index; see \link[DisImpact]{di_80_index}; defaults to 0.80.}

\item{di_80_index_reference_group}{Either \code{'overall'}, \code{'hpg'}, \code{'all but current'}, or a character value specifying a group from \code{group_var} to be used as the reference group for comparison using 80\% index.}

\item{before_with_statement}{Character value to be added to the SQL query to allow for modification.  Defaults to \code{''} (empty string).}

\item{after_with_statement}{Character value to be added to the SQL query to allow for modification.  Defaults to \code{''} (empty string).}

\item{end_of_select_statement}{Character value to be added to the SQL query to allow for modification.  Defaults to \code{''} (empty string).}

\item{where_statement}{Character value to be added to the SQL query to allow for modification.  Defaults to \code{''} (empty string).}

\item{select_statement_add}{Character value to be added to the SQL query to allow for modification.  Defaults to \code{''} (empty string).}
}
\value{
A character value (SQL query) that could be executed on a database.
}
\description{
Generate SQL code that calculates disproportionate impact via the percentage point gap (PPG), proportionality index, and 80\% index methods for a specified table name, success variable, group variable, and cohort variable.  This is the workhorse function leveraged by the \link[DisImpact]{di_iterate_sql} function.
}
