% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_matrix_calculation.R
\name{null_score}
\alias{null_score}
\title{Calculation of diffusion null scores for each node}
\usage{
null_score(graph, initial.score, damping = 0.7, N.repeat = 10, n.cores = 1)
}
\arguments{
\item{graph}{an igraph object with the length of N}

\item{initial.score}{a named vector of node preferences of length N served as the initial values for diffusion algorithm.}

\item{damping}{The damping factor of the diffusion algorithm.}

\item{N.repeat}{number of permutation repeats of null scores.}

\item{n.cores}{number of cores for parallel processing.}
}
\value{
a matrix of null diffusion scores (\code{N.repeat}—BY—number_of_nodes).
}
\description{
Calculation of diffusion null scores for each node
}
\details{
This function calculates the null diffusion score for each node using the personalized page rank algorithm.
The initial values are obtained by permuting the given \code{initial.score}
}
\examples{
graph = graph_generation(n.nodes = 10, prob.connection = 0.5)
initial_score = c(rep(0,5),0.2, 0.3, 0, 0, 0.5)
names(initial_score) = igraph::V(graph)
Null = null_score(graph, initial_score)

}
