% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actual_score_calculation.R
\name{actual_score}
\alias{actual_score}
\title{Calculation of diffusion score for each node}
\usage{
actual_score(graph, initial.score, damping = 0.7)
}
\arguments{
\item{graph}{an igraph object with the length of N}

\item{initial.score}{a named vector of node preferences of length N served as the initial values for diffusion algorithm.}

\item{damping}{The damping factor of the diffusion algorithm.}
}
\value{
a vector of diffusion scores.
}
\description{
Calculation of diffusion score for each node
}
\details{
This function calculates the diffusion score for each node using the personalized page rank algorithm.
}
\examples{
graph = graph_generation(n.nodes = 10, prob.connection = 0.5)
initial_score = c(rep(0,5),0.2, 0.3, 0, 0, 0.5)
names(initial_score) = igraph::V(graph)
Actual_score = actual_score(graph = graph, initial.score = initial_score, damping = 0.7)

}
