% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiffCorr.R
\name{plotDiffCorrGroup}
\alias{plotDiffCorrGroup}
\title{Plot DiffCorr group}
\usage{
plotDiffCorrGroup(
  data,
  groups1 = NULL,
  groups2 = NULL,
  group1.no = NULL,
  group2.no = NULL,
  g1,
  g2,
  g1.order = NULL,
  g2.order = NULL,
  title1 = NULL,
  title2 = NULL,
  ...
)
}
\arguments{
\item{data}{a data matrix or data frame}

\item{groups1}{a vector of row group membership as produced by cutree under condition 1}

\item{groups2}{a vector of row group membership as produced by cutree under condition 2}

\item{group1.no}{the group number to be plotted (condition 1)}

\item{group2.no}{the group number to be plotted (condition 2)}

\item{g1}{a vector describing the columns of the data belonging to condition 1}

\item{g2}{a vector describing the columns of the data belonging to condition 2}

\item{g1.order}{whether or not to order the columns of the data
matrix for condition 1.  If "average", then the columns are ordered
by the average expression value.  If the name of a gene (row),
then the columns are orderd according to the expression levels of
that gene.  If NULL, columns remain in their original order.}

\item{g2.order}{See g1.order}

\item{title1}{A title for the left hand graph}

\item{title2}{A title for the right hand graph}

\item{...}{other parameters to be passed to this function}
}
\value{
a graph
}
\description{
Plot DiffCorr group
}
\examples{
library(pcaMethods)
data(golub, package = "multtest")
hc.mol1 <- cluster.molecule(golub[, 1:27], "pearson", "average")
hc.mol2 <- cluster.molecule(golub[, 28:38], "pearson", "average")
g1 <- cutree(hc.mol1, h=0.4)
g2 <- cutree(hc.mol2, h=0.4)
##
plotDiffCorrGroup(golub, g1, g2, 21, 24, 1:27, 28:38,
                   scale.center=TRUE, scale.scale=TRUE,
                   ylim=c(-5,5))
}
\author{
Atsushi Fukushima
}
