% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Av..R
\name{Av.}
\alias{Av.}
\title{Varying Life Insurance: Arithmetic Progression}
\usage{
Av.(
  x,
  h,
  n,
  k = 1,
  r = 1,
  i = 0.04,
  data,
  prop = 1,
  assumption = "none",
  variation = "none",
  cap = 1
)
}
\arguments{
\item{x}{An integer. The age of the insuree.}

\item{h}{An integer. The deferral period.}

\item{n}{An integer. Number of years of coverage.}

\item{k}{An integer. Fractions per year.}

\item{r}{The variation rate. A numeric type value.}

\item{i}{The interest rate. A numeric type value.}

\item{data}{A data.frame of the mortality table, with the first column being the age and the second one the probability of death.}

\item{prop}{A numeric value. It represents the proportion of the mortality table being used (between 0 and 1).}

\item{assumption}{A character string. The assumption used for fractional ages ("UDD" for uniform distribution of deaths, "constant" for constant force of mortality and "none" if there is no fractional coverage).}

\item{variation}{A character string. "inter" if the variation it's interannual or "intra" if it's intra-annual.}

\item{cap}{A numeric type value. Amount insured for the first year/period.}
}
\value{
Returns a numeric value (actuarial present value).
}
\description{
Calculates the present value of a varying life insurance according to a arithmetic progression.
}
\note{
For an increasing life insurance coverage, 'r' must be 1.
}
\examples{
Av.(43,0,4,1,0.7,0.04,CSO80MANB,1,"none","none",1)
Av.(37,1,6,1,0.3,0.04,CSO80MANB,1,"none","none",1)
Av.(25,2,3,2,0.6,0.04,CSO80MANB,1,"constant","inter",1)
Av.(37,3,6,4,0.5,0.04,CSO80MANB,1,"constant","intra",1)
Av.(40,3,5,2,0.4,0.04,CSO80MANB,1,"UDD","inter",1)
Av.(50,2,4,4,0.6,0.04,CSO80MANB,1,"UDD","intra",1)

}
\references{
Chapter 4 of  Actuarial Mathematics for Life Contingent Risks (2009) by Dickson, Hardy and Waters.
}
\keyword{Arithmetic}
\keyword{Insurance}
\keyword{Life}
\keyword{Progression}
