% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{match.call.defaults}
\alias{match.call.defaults}
\title{Argument matching with defaults}
\usage{
match.call.defaults(
  definition = sys.function(sys.parent()),
  call = sys.call(sys.parent()),
  expand.dots = TRUE,
  envir = parent.frame(2L)
)
}
\arguments{
\item{definition}{a function, by default the function from which match.call is called. See details.}

\item{call}{an unevaluated call to the function specified by definition, as generated by call.}

\item{expand.dots}{ogical. Should arguments matching \code{...} in the call be included or left as a \code{...} argument?}

\item{envir}{an environment, from which the \code{...} in call are retrieved, if any.}
}
\value{
An object of class call.
}
\description{
This is a version of \code{\link{match.call}} which also includes default arguments.
}
\examples{

foo <- function(x=NULL,y=NULL,z=4, dots=TRUE, ...) {
  match.call.defaults(expand.dots=dots)
}


}
\author{
Neal Fultz
}
