% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin_time_variant_2sex.R
\name{kin_time_variant_2sex}
\alias{kin_time_variant_2sex}
\title{Estimate kin counts in a time variant framework (dynamic rates) in a two-sex framework (Caswell, 2022)}
\usage{
kin_time_variant_2sex(
  pf = NULL,
  pm = NULL,
  ff = NULL,
  fm = NULL,
  sex_focal = "f",
  birth_female = 1/2.04,
  pif = NULL,
  pim = NULL,
  nf = NULL,
  nm = NULL,
  output_cohort = NULL,
  output_period = NULL,
  output_kin = NULL,
  list_output = FALSE
)
}
\arguments{
\item{pf}{numeric. A vector (atomic) or  matrix with probabilities (or survival ratios, or transition between age class in a more general perspective) with rows as ages (and columns as years in case of matrix, being the name of each col the year).}

\item{pm}{numeric. A vector (atomic) or  matrix with probabilities (or survival ratios, or transition between age class in a more general perspective) with rows as ages (and columns as years in case of matrix, being the name of each col the year).}

\item{ff}{numeric. Same as pf but for fertility rates.}

\item{fm}{numeric. Same as pm but for fertility rates.}

\item{sex_focal}{character. "f" for female or "m" for male.}

\item{birth_female}{numeric. Female portion at birth. This multiplies \code{f} argument. If \code{f} is already for female offspring, this needs to be set as 1.}

\item{pif}{numeric. For using some specific age distribution of childbearing for mothers (same length as ages). Default \code{NULL}.}

\item{pim}{numeric. For using some specific age distribution of childbearing for fathers (same length as ages). Default \code{NULL}.}

\item{nf}{numeric. Same as pf but for population distribution (counts or \verb{\%}). Optional.}

\item{nm}{numeric. Same as pm but for population distribution (counts or \verb{\%}). Optional.}

\item{output_cohort}{integer. Vector of year cohorts for returning results. Should be within input data years range.}

\item{output_period}{integer. Vector of period years for returning results. Should be within input data years range.}

\item{output_kin}{character. kin types to return: "m" for mother, "d" for daughter,...}

\item{list_output}{logical. Results as a list with years elements (as a result of \code{output_cohort} and \code{output_period} combination), with a second list of \code{output_kin} elements, with focal´s age in columns and kin ages in rows (2 * ages, last chunk of ages for death experience). Default \code{FALSE}}
}
\value{
A data.frame with year, cohort, Focal´s age, related ages, sex and type of kin (for example \code{d} is daughter, \code{oa} is older aunts, etc.), including living and dead kin at that age and sex.
}
\description{
Two-sex matrix framework for kin count estimates with varying rates.
This produces kin counts grouped by kin, age and sex of each relatives at each Focal´s age.
For example, male cousins from aunts and uncles from different sibling's parents are grouped in one male count of cousins.
}
\details{
See Caswell (2022) for details on formulas.
}
