% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_helper_functions.R
\name{tidy.diagnosis}
\alias{tidy.diagnosis}
\title{Tidy diagnosis}
\usage{
\method{tidy}{diagnosis}(x, conf.int = TRUE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A diagnosis object generated by \code{diagnose_design}.}

\item{conf.int}{Logical indicating whether or not to include a
confidence interval in the tidied output. Defaults to ‘TRUE’.}

\item{conf.level}{The confidence level to use for the confidence
interval if ‘conf.int = TRUE’. Must be strictly greater than 0 and less
than 1. Defaults to 0.95, which corresponds to a 95 percent confidence
interval.}

\item{...}{extra arguments (not used)}
}
\value{
A data.frame with columns for diagnosand names, estimated diagnosand values,
bootstrapped standard errors and confidence intervals
}
\description{
Tidy diagnosis
}
\examples{

effect_size <- 0.1
design <-
  declare_model(
    N = 100,
    U = rnorm(N),
    X = rnorm(N),
    potential_outcomes(Y ~ effect_size * Z + X + U)
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_assignment(Z = complete_ra(N)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE", label = "unadjusted") + 
  declare_estimator(Y ~ Z + X, inquiry = "ATE", label = "adjusted")

diagnosis <- diagnose_design(design, sims = 100)

tidy(diagnosis)

}
