% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasum.R
\name{Datum}
\alias{Datum}
\title{Summarize a Single Vector}
\usage{
Datum(data)
}
\arguments{
\item{data}{A numeric, character, factor, or other vector.}
}
\value{
A one-row \code{data.frame} with summary statistics.
}
\description{
Summarizes a single vector by calculating a consistent set of statistics.
Numeric vectors include mean/median/variance/sd/min/max/range/skewness/kurtosis
and a normality decision. Character/factor vectors report the mode only.
}
\examples{
Datum(rnorm(100))
Datum(factor(sample(letters[1:3], 20, TRUE)))
}
