% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataSpaceConnection.R
\name{DataSpaceConnection}
\alias{DataSpaceConnection}
\title{The DataSpaceConnection class}
\description{
The DataSpaceConnection class

The DataSpaceConnection class
}
\section{Constructor}{

\code{\link{connectDS}}
}

\examples{
\dontrun{
# Create a connection (Initiate a DataSpaceConnection object)
con <- connectDS()
con

# Connect to cvd408
# https://dataspace.cavd.org/cds/CAVD/app.view#learn/learn/Study/cvd408?q=408
cvd408 <- con$getStudy("cvd408")

# Connect to all studies
cvd <- con$getStudy("cvd408")

# Connect to the NYVAC durability comparison group
# https://dataspace.cavd.org/cds/CAVD/app.view#group/groupsummary/220
nyvac <- con$getGroup(220)

# Refresh the connection object to update available studies and groups
con$refresh()
}

}
\seealso{
\code{\link{connectDS}} \code{\link{DataSpaceR-package}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{config}}{A list. Stores configuration of the connection object such as
URL, path and username.}

\item{\code{availableStudies}}{A data.table. The table of available studies.}

\item{\code{availableGroups}}{A data.table. The table of available groups.}

\item{\code{availablePublications}}{A data.table. The table of available
publications.}

\item{\code{mabGridSummary}}{A data.table. The filtered grid with updated
\code{n_} columns and \code{geometric_mean_curve_ic50}.}

\item{\code{mabGrid}}{A data.table. The filtered mAb grid.}

\item{\code{virusMetadata}}{A data.table. Metadata about all viruses in the
DataSpace.}

\item{\code{virusNameMappingTables}}{A list of data.table objects. This
list contains `virusMetadataAll`, `virusLabId`, and `virus_synonym`
which are described in the vignette `Virus_Name_Mapping_Tables`.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DataSpaceConnection-new}{\code{DataSpaceConnection$new()}}
\item \href{#method-DataSpaceConnection-print}{\code{DataSpaceConnection$print()}}
\item \href{#method-DataSpaceConnection-getStudy}{\code{DataSpaceConnection$getStudy()}}
\item \href{#method-DataSpaceConnection-getGroup}{\code{DataSpaceConnection$getGroup()}}
\item \href{#method-DataSpaceConnection-filterMabGrid}{\code{DataSpaceConnection$filterMabGrid()}}
\item \href{#method-DataSpaceConnection-resetMabGrid}{\code{DataSpaceConnection$resetMabGrid()}}
\item \href{#method-DataSpaceConnection-getMab}{\code{DataSpaceConnection$getMab()}}
\item \href{#method-DataSpaceConnection-downloadPublicationData}{\code{DataSpaceConnection$downloadPublicationData()}}
\item \href{#method-DataSpaceConnection-refresh}{\code{DataSpaceConnection$refresh()}}
\item \href{#method-DataSpaceConnection-clone}{\code{DataSpaceConnection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-new"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-new}{}}}
\subsection{Method \code{new()}}{
Initialize a \code{DataSpaceConnection} object.
See \code{\link{connectDS}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$new(
  login = NULL,
  password = NULL,
  verbose = FALSE,
  onStaging = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{login}}{A character. Optional argument. If there is no netrc file a
temporary one can be written by passing login and password of an active
DataSpace account.}

\item{\code{password}}{A character. Optional. The password for the selected
login.}

\item{\code{verbose}}{A logical. Whether to print the extra details for
troubleshooting.}

\item{\code{onStaging}}{A logical. Whether to connect to the staging server
instead of the production server.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `DataSpaceConnection` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-print"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-print}{}}}
\subsection{Method \code{print()}}{
Print the \code{DataSpaceConnection} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-getStudy"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-getStudy}{}}}
\subsection{Method \code{getStudy()}}{
Create a \code{\link{DataSpaceStudy}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$getStudy(studyName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{studyName}}{A character. Name of the study to retrieve.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-getGroup"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-getGroup}{}}}
\subsection{Method \code{getGroup()}}{
Create a \code{\link{DataSpaceStudy}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$getGroup(groupId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{groupId}}{An integer. ID of the group to retrieve.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-filterMabGrid"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-filterMabGrid}{}}}
\subsection{Method \code{filterMabGrid()}}{
Filter rows in the mAb grid by specifying the values to keep in the
columns found in the \code{mabGrid} field. It takes the column and the
values and filters the underlying tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$filterMabGrid(using, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{using}}{A character. Name of the column to filter.}

\item{\code{value}}{A character vector. Values to keep in the mAb grid.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-resetMabGrid"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-resetMabGrid}{}}}
\subsection{Method \code{resetMabGrid()}}{
Reset the mAb grid to the unfiltered state.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$resetMabGrid()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-getMab"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-getMab}{}}}
\subsection{Method \code{getMab()}}{
Create a \code{\link{DataSpaceMab}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$getMab()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-downloadPublicationData"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-downloadPublicationData}{}}}
\subsection{Method \code{downloadPublicationData()}}{
Download publication data for a chosen publication.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$downloadPublicationData(
  publicationId,
  outputDir = getwd(),
  unzip = TRUE,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{publicationId}}{A character/integer. ID for the publication to
download data for.}

\item{\code{outputDir}}{A character. Path to directory to download publication
data.}

\item{\code{unzip}}{A logical. If TRUE, unzip publication data to outputDir.}

\item{\code{verbose}}{A logical. Default TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-refresh}{}}}
\subsection{Method \code{refresh()}}{
Refresh the connection object to update available studies and groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DataSpaceConnection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DataSpaceConnection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DataSpaceConnection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
