% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt.choose.rows.dt.choose.cols.dt.count.rows.R
\name{dt.count.rows}
\alias{dt.count.rows}
\title{dt.count.rows}
\source{
DTwrappers::create.dt.statement

DTwrappers::eval.dt.statement
}
\usage{
dt.count.rows(
  dt.name,
  the.filter = NULL,
  grouping.variables = NULL,
  sortby.group = TRUE,
  count.name = "N",
  return.as = "result",
  envir = .GlobalEnv
)
}
\arguments{
\item{dt.name}{a character value specifying the name of a data.frame or data.table object to select data from.  A variable called dat should be referred to with dt.name = "dat" when using the function.}

\item{the.filter}{a character value, numeric vector, logical vector, or expression stating the logical operations used to filter the data.  The filtering step will be applied prior to generating the counts.  Defaults to NULL unless otherwise specified.  Character values such as 'Age < 50' or 'c(1:3, 7:10)' may be used.  Numeric vectors such as c(1:3, 7:10) that specify the row indices may be used.  Logical vectors will be converted to a numeric filter, e.g. c(TRUE, TRUE, FALSE) will become 1:2 to signify which rows should be selected.  Expressions may be used to specify a logical operation such as expression(Age < 50) as well.  Defaults to NULL to indicate that no filtering of the data should be applied.}

\item{grouping.variables}{A character or numeric vector specifying the variables to perform the calculations on. For character vectors, the values may be either column names of the data or calculations based upon them (see the vignette for examples).  For numeric vectors, only the values of unique(floor(grouping.variables)) that are in 1:ncol() of your data will be used.  Then these indices will be mapped to the corresponding column names from the data.  When NULL, no grouping will be performed.}

\item{sortby.group}{a character value specifying whether the table of counts should be sorted by group ("sorted") or as is (any other selected value).  Defaults to "sorted".}

\item{count.name}{a character value specifying the name of the column of counts in the resulting table.  This value defaults to "N" unless otherwise specified.}

\item{return.as}{a character value specifying what output should be returned.  return.as = "result" provides the table of counts.  return.as = "code" provides a data.table coding statement that can generate the table of counts.  return.as = "all" provides both the resulting table and the code.  If the coding statement was specified using calls to get() or eval(), then both an original.statement and the resulting code (a translated statement from the getDTeval package) will be provided.}

\item{envir}{the environment in which the code would be evaluated; .GlobalEnv by default.}
}
\value{
Depending on the value of return.as, the output will be a) a character value (return.as = 'code'), b) a coding output, typically a data.table (return.as = 'result'), or c) a list containing both the code and output (return.as = 'all')
}
\description{
This function counts the number of qualifying rows in a data.table or data.frame object.  It is built as a wrapper function of data.table's filter (the i step).  These counts may be comprehensive for the entire table or conducted in groups.  The full data can also be filtered for qualifying cases prior to conducting the counts.  This function returns a data.table object that shows the counts in one column along with additional columns for any specified grouping variables.  Options also exist to return a data.table coding statement (result = "code") for educational purposes or both the result and the code together (result = "all").  For examples, please see the vignette.
}
\note{
the data.frame dat will be converted to a data.table object to facilitate efficient selection.
}
\examples{
n <- nrow(iris)
dat <- data.table::as.data.table(x = iris[sample(x = 1:n, size = n, replace = FALSE),])
dt.count.rows(dt.name = "dat", return.as = "all")

}
