% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DGaoPC.R
\name{DGaoPC}
\alias{DGaoPC}
\title{Distributed Gao Principal Component Analysis}
\usage{
DGaoPC(data, m, n1, K)
}
\arguments{
\item{data}{A numeric matrix containing the total dataset.}

\item{m}{An integer specifying the number of principal components for the first stage.}

\item{n1}{An integer specifying the length of each data subset.}

\item{K}{An integer specifying the number of nodes.}
}
\value{
A list with the following components:
\describe{
  \item{AG1}{List of estimated loading matrices for the first-stage components for each node.}
  \item{AG2}{List of estimated loading matrices for the second-stage components for each node.}
  \item{DG3}{List of diagonal residual variance matrices for each node.}
  \item{sGhat}{List of covariance matrices of reconstructed data for each node.}
}
}
\description{
Performs distributed Gao-type principal component analysis
on a numeric dataset split across multiple nodes.
}
\examples{
set.seed(123)
data <- matrix(rnorm(500), nrow = 100, ncol = 5)
DGaoPC(data = data, m = 3, n1 = 20, K = 5)

}
