% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPtree.R
\name{SampleDPTreeDensity}
\alias{SampleDPTreeDensity}
\title{Sample a copula observation from a realized distribution from D-P tree.}
\usage{
SampleDPTreeDensity(nsam, d)
}
\arguments{
\item{nsam}{A positive integer. The sample size.}

\item{d}{A \eqn{2^m} by \eqn{2^m} matrix, m being the approximating level.
Normalized measures for all \eqn{2^m} by \eqn{2^m} sub-partititons on copula space
given by the realized distribution from D-P tree, as returned by \code{DPTreeDensity}.}
}
\value{
An array of dimension nsam by 2. The values of PDF of the input D-P tree distribution evaluated at the input points.
}
\description{
\code{SampleDPTreeDensity} returns
a copula sample from a realized distribution from D-P tree.
}
\examples{
SampleDPTreeDensity(10, DPTreePMeanDensity(DPTreePrior(m=2, z=1)))
}
\references{
\insertRef{DPtree}{DPtree}
}
