% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataAccess.R
\name{meanDataAccess}
\alias{meanDataAccess}
\title{Differentially Private Mean Data Access Function}
\usage{
meanDataAccess(x, lower.bound, upper.bound)
}
\arguments{
\item{x}{Dataset whose mean is desired.}

\item{lower.bound}{Scalar representing the global or public lower bound on
values of x.}

\item{upper.bound}{Scalar representing the global or public upper bound on
values of x.}
}
\value{
List of the true mean and the sensitivity calculated based on
theoretical values.
}
\description{
This function performs the data access step in the computation of a
differentially private mean. The true values are computed using
\code{\link[base]{mean}}, while the sensitivities are calculated based on
bounded and unbounded differential privacy \insertCite{Kifer2011}{DPpack}
according to the theoretical values \insertCite{Liu2019b}{DPpack}. For the
mean, the sensitivities based on bounded and unbounded differential privacy
are identical, so only one value is returned.
}
\examples{
meanDataAccess(c(1,4,3,2), 0, 5)

}
\references{
\insertRef{Liu2019b}{DPpack}

\insertRef{Kifer2011}{DPpack}
}
\keyword{internal}
