% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatFunctions.R
\name{histogramDP}
\alias{histogramDP}
\title{Differentially Private Histogram}
\usage{
histogramDP(
  x,
  eps,
  lower.bound,
  upper.bound,
  breaks = "Sturges",
  normalize = FALSE,
  which.sensitivity = "bounded",
  mechanism = "Laplace",
  delta = 0,
  type.DP = "aDP",
  allow.negative = FALSE
)
}
\arguments{
\item{x}{Numeric vector from which the histogram will be formed.}

\item{eps}{Positive real number defining the epsilon privacy budget.}

\item{lower.bound}{Scalar representing the global or public lower bound on
values of x.}

\item{upper.bound}{Scalar representing the global or public upper bound on
values of x.}

\item{breaks}{Identical to the argument with the same name from
\code{\link[graphics]{hist}}.}

\item{normalize}{Logical value. If FALSE (default), returned histogram counts
correspond to frequencies. If TRUE, returned histogram counts correspond to
densities (i.e. area of histogram is one).}

\item{which.sensitivity}{String indicating which type of sensitivity to use.
Can be one of \{'bounded', 'unbounded', 'both'\}. If 'bounded' (default),
returns result based on bounded definition for differential privacy. If
'unbounded', returns result based on unbounded definition. If 'both',
returns result based on both methods \insertCite{Kifer2011}{DPpack}. Note
that if 'both' is chosen, each result individually satisfies (eps,
delta)-differential privacy, but may not do so collectively and in
composition. Care must be taken not to violate differential privacy in this
case.}

\item{mechanism}{String indicating which mechanism to use for differential
privacy. Currently the following mechanisms are supported: \{'Laplace',
'Gaussian', 'analytic'\}. Default is Laplace. See \code{\link{LaplaceMechanism}}
and \code{\link{GaussianMechanism}} for descriptions of the supported
mechanisms.}

\item{delta}{Nonnegative real number defining the delta privacy parameter. If
0 (default), reduces to eps-DP.}

\item{type.DP}{String indicating the type of differential privacy desired for
the Gaussian mechanism (if selected). Can be either 'pDP' for probabilistic
DP \insertCite{Machanavajjhala2008}{DPpack} or 'aDP' for approximate DP
\insertCite{Dwork2006b}{DPpack}. Note that if 'aDP' is chosen, epsilon must
be strictly less than 1.}

\item{allow.negative}{Logical value. If FALSE (default), any negative values
in the sanitized histogram due to the added noise will be set to 0. If
TRUE, the negative values (if any) will be returned.}
}
\value{
Sanitized histogram based on the bounded and/or unbounded definitions
of differential privacy.
}
\description{
This function computes a differentially private histogram from a vector at
user-specified privacy levels of epsilon and delta. A histogram object is
returned with sanitized values for the counts for easy plotting.
}
\examples{
x <- stats::rnorm(500)
graphics::hist(x) # Non-private histogram
result <- histogramDP(x, 1, -3, 3)
plot(result) # Private histogram

graphics::hist(x, freq=FALSE) # Normalized non-private histogram
result <- histogramDP(x, .5, -3, 3, normalize=TRUE,
  which.sensitivity='unbounded', mechanism='Gaussian', delta=0.01,
  allow.negative=TRUE)
plot(result) # Normalized private histogram (note negative values allowed)

}
\references{
\insertRef{Dwork2006a}{DPpack}

\insertRef{Kifer2011}{DPpack}

\insertRef{Machanavajjhala2008}{DPpack}

\insertRef{Dwork2006b}{DPpack}
}
