% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNMF.R
\name{DNMF}
\alias{DNMF}
\title{Discriminant Non-Negative Matrix Factorization.}
\usage{
DNMF(
  data,
  trainlabel,
  r = 2,
  gamma = 0.1,
  delta = 1e-04,
  maxIter = 1000,
  tol = 1e-07,
  log = TRUE,
  plotit = FALSE,
  checkH = TRUE,
  ...
)
}
\arguments{
\item{data}{a matrix, like expression profilings of some samples. the columns are samples and the rows are gene's expression.}

\item{trainlabel}{a numeric vector of sample type of all the samples, this vector should ONLY contain 1 and 2 so far and length of it should equal the column (sample) size of data.}

\item{r}{the dimension of expected reduction dimension, with the default value 2.}

\item{gamma}{the tradeoff value for the within scatter matrix, with the default value 0.1.}

\item{delta}{the tradeoff value for the between scatter matrix, with the default value 1e-4.}

\item{maxIter}{the maximum iteration of update rules, with the default value 1000.}

\item{tol}{the toleration of coverange, with the default value 1e-7.}

\item{log}{log2 data. Default is TRUE.}

\item{plotit}{whether plot H (V=WH). Default: FALSE.}

\item{checkH}{whether or not check H. Default: TRUE. This parameter aims to 
check whether or not the H safisfy the discriminant metagenes. Usually, this
should be TRUE.}

\item{...}{to gplots::heatmap.2}
}
\description{
Discriminant Non-Negative Matrix Factorization, DNMF, is to extend the Non-negative Matrix Factorization algorithm in 
order to extract features that enforce not only the spatial locality, but
 also the separability between classes in a discriminant manner.
}
\details{
The main algorithm is based on 
\href{https://pubmed.ncbi.nlm.nih.gov/16722172/}{Zafeiriou, S., et al. 
(2006) Exploiting discriminant information in 
nonnegative matrix factorization with application to frontal face 
verification, IEEE transactions on neural networks, 17, 683-695}, 
with some \strong{CORRECTIONs}.
}
\examples{
dat <- rbind(matrix(c(rep(3, 16), rep(8, 24)), ncol=5), 
matrix(c(rep(5, 16), rep(5, 24)), ncol=5), 
matrix(c(rep(18, 16), rep(7, 24)), ncol=5)) + 
matrix(runif(120,-1,1), ncol=5)
trainlabel <- c(1,1,2,2,2)

DNMF_result <- DNMF(dat, trainlabel, r=2)


\dontrun{
# Gene ranking. dat is the raw read count maatrix with sample in column.

#normalising dat
Sizefactors <- DESeq::estimateSizeFactorsForMatrix(dat)
dat = sweep(dat, 2, Sizefactors, `/`)

res <- DNMF(dat, trainlabel, r=2)
rnk <- res$rnk

#The end of gene ranking exmaples

#Other exmaples
DNMF_result <- DNMF(dat, trainlabel, r=2, gamma=0.1, delta=0.0001, plotit=TRUE)
}

}
\author{
Zhilong Jia and Xiang Zhang
}
