% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_match.R
\name{match_func}
\alias{match_func}
\title{Estimate Inverse Mapping}
\usage{
match_func(knots, vals, new_vals, lims, get_func = FALSE)
}
\arguments{
\item{knots}{Vector containing knots for the distribution estimate.}

\item{vals}{Vector containing distribution values corresponding to the knots.}

\item{new_vals}{Vector containing distribution values for which the knots
are unknown. If missing, \code{match_func()} simply returns the map function.}

\item{lims}{Vector providing the range of the knot values for mapping. If
missing, these values are estimated from the given knots.}

\item{get_func}{Flag for returning the map function if \code{new_vals} is
provided. If \code{TRUE}, \code{match_func()} returns a named list with two components-
\code{mapped} and \code{func} (mapped knots for \code{new_vals} and the mapping function,
respectively). Defaults to \code{FALSE}.}
}
\value{
If \code{new_vals} is missing, a function performing interpolation
(linear or constant) of the given data points.

If \code{get_func = FALSE}, a vector containing the matched knots that will
produce \code{new_vals} for the map \eqn{f}.

If \code{get_func = TRUE}, a named list with two components- \code{mapped} and \code{func}
(mapped knots for \code{new_vals} and the mapping function, respectively).
}
\description{
This function estimates an inverse map \eqn{g} for a given set of knots
(input) and values (output) corresponding to a certain map \eqn{f} \emph{i.e.},
given \eqn{x, y | f: x --> y}, \code{match_func()} estimates \eqn{g: y --> x}
using linear interpolation.
}
\examples{
set.seed(654321)
x <- rnorm(100, 1, 0.5)
F <- ecdf(x)
fval <- F(x)
map <- match_func(knots = x, vals = fval)

x2 <- rnorm(20, 0.8, 0.5)
F2 <- ecdf(x2)
fval2 <- F2(x2)
matched <- match_func(knots = x, vals = fval, new_vals = fval2)

## Plot histograms...
opar <- par(mfrow = c(1, 3))
hist(x);    hist(x2);    hist(matched)
par(opar)              # Reset par

}
\keyword{function-approximation}
\keyword{inverse-map}
