% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DERLS_Woodbury.R
\name{DERLS_Woodbury}
\alias{DERLS_Woodbury}
\title{Distributed Exponentially Weighted Recursive Least Squares (DERLS) using Woodbury Identity}
\description{
  Impute missing values in the response variable Y using the distributed ERLS method with the Woodbury Identity.
  Multiple independent runs are performed to stabilize coefficient estimates.
  Missing values are imputed recursively and refined over multiple iterations.
}
\usage{
DERLS_Woodbury(data, rho, lambda, R, nb)
}
\arguments{
  \item{data}{
    A data frame where:
    \describe{
      \item{First column:}{Response Y (with possible NAs)}
      \item{Remaining columns:}{Predictors X}
    }
  }
  \item{rho}{
    Regularization parameter.
  }
  \item{lambda}{
    Forgetting factor.
  }
  \item{R}{
    Number of independent runs to stabilize estimates.
  }
  \item{nb}{
    Number of iterations per run.
  }
}
\details{
  This function implements the Distributed Exponentially Weighted Recursive Least Squares (DERLS) method
  using the Woodbury Identity for efficient updates of the covariance matrix.
  The key steps include:
  \enumerate{
    \item Initial imputation of missing values.
    \item Recursive updates of the regression coefficients using the ERLS algorithm with the Woodbury Identity.
    \item Multiple independent runs to stabilize the coefficient estimates.
    \item Final prediction of missing values using the averaged coefficients.
  }
  The Woodbury Identity is used to efficiently update the covariance matrix Pstar during each iteration,
  making the algorithm computationally efficient and suitable for large datasets.
}
\value{
  A list containing:
  \describe{
    \item{Yhat}{
      Imputed response vector.
    }
    \item{betahat}{
      Estimated coefficient vector.
    }
  }
}
\examples{
set.seed(123)
n <- 60
data <- data.frame(
  Y = c(rnorm(n - 10), rep(NA, 10)),  # 50 observed+10 missing
  X1 = rnorm(n),
  X2 = rnorm(n)
)
result <- DERLS_Woodbury(data, rho = 0.01, lambda = 0.95, R = 3, nb = 50)
head(result$Yhat)  # inspect imputed Y
result$betahat      # inspect estimated coefficients
}
