% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_digit.R
\name{calculate_check_digit}
\alias{calculate_check_digit}
\title{Calculate Check Digit Using DIN/ISO 7064, Mod 11,10}
\usage{
calculate_check_digit(patid)
}
\arguments{
\item{patid}{A numeric or character string representing the ID.
It should be either 9 or 10 digits long.}
}
\value{
An integer representing the computed check digit (0-9).
  Returns `NA` if the input is invalid.
}
\description{
This function calculates the check digit for a given ID
  based on the DIN ISO 7064, Mod 11,10 algorithm.
}
\details{
The function processes the input `patid` as follows:
- If the input has 10 digits and does not start with `0`,
  it is assumed to be a patient ID with a check digit. The check digit is removed.
- If the input has 9 digits, a leading `0` is added.
- If the input has 10 digits and starts with `0`, it is already in the expected format.
- If the input does not match these cases, an error message is returned.

The check digit is calculated using the ISO 7064, Mod 11,10 method.
}
\examples{
calculate_check_digit("100000138")  # Returns check digit (1) for this ID
calculate_check_digit(123456789)    # Works with numeric input as well (6)

}
