% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SurveyLoops.R
\name{surveyLoops}
\alias{surveyLoops}
\title{Survey Loops}
\usage{
surveyLoops(surveyParameters, loopVariable, loopSequence, plotResult)
}
\arguments{
\item{surveyParameters}{list of parameters (object class \code{surveySim})}

\item{loopVariable}{variable to be looped. Can be any of the variables that exist in \code{surveyParameters} \itemize{
\item \code{col.width} - vector of numbers with distances between STP rows
\item \code{grid.type} - vector of strings with names of grid types
\item \code{simulations} - vector of numbers with numbers of simulations
\item \code{area} - \strong{list} with 2 vectors, one for x and one for y of area (vectors MUST be same length)
\item \code{site.density} - vector with numbers of site density OR \strong{list} with 2 vectors, one with minimum site densities, one with maximum (vectors MUST be same length)
\item \code{site.area} - vector with numbers of site areas OR \strong{list} with 4 vectors, one with minimums, one with maximums, one with means, one with st.devs (vectors MUST be same length)
\item \code{overlap} - vector of numbers with varying overlaps
\item \code{obj.density} - vector with varying artifact density OR \strong{list} with 2 vectors, one with minimum artifact densities, one with maximum (vectors MUST be same length)
\item \code{obj.distribution} - vector of names of artifact distribution
\item \code{survey.radius} vector with varying survey radii
}}

\item{loopSequence}{object with varying values, as defined above}

\item{plotResult}{which results from the summary table will be plotted:\itemize{
\item \code{surveysPerSim} - plots the total number of surveys created in each simulation
\item \code{sitesFound} - plots the frequency of sites found
\item \code{sitesFoundOnArtifacts} - plots the frequency of sites found based on surveys finding at least one artifact
\item \code{artifactsPerSurvey} - plots the average number of artifacts found per survey in each simulation
\item \code{successRateIndex} - plots the success rate index (ratio of survey pits that found a site over total number of survey pits made)
}}
}
\value{
A list with five objects: \tabular{ll}{
\code{surveysPerSim} \tab A matrix with the number of survey pits done in each simulation.\cr
\tab \cr
\code{sitesFound} \tab A matrix with the summary statistics about frequency of sites found in each simulation. \cr
\tab \cr
\code{sitesFoundOnArtifacts} \tab A matrix with the summary statistics about frequency of sites detected based on artifacts found in survey pits in each simulation. \cr
\tab \cr
\code{artifactsPerSurver} \tab A matrix with the summary statistics about artifacts found per survey pit in each simulation. \cr
\tab \cr
\code{succesRateIndex} \tab A matrix with the summary statistics about success rate (number of succesful survey pits/total survey pits) in each simulation.\cr
}
}
\description{
Perform multiple survey simulations changing values on one variable and plot the results
}
\details{
\code{surveyLoops()} will run a series of simulations along one variable with values
provided by user. Through this function, the user can simulate and evaluate the changes
in efficiency and efficacy of specific variables, while holding every other value constant. The function
runs multiple instances of \code{surveySim()} using values of \code{surveyParameters} and replacing one of them with a sequence of values offered by the user.
}
\examples{
\donttest{
#Loop the impact of increasing distances between survey rows
width.loop<-surveyLoops(parametersExample,"col.width",c(50,75,100,125,150),"sitesFound")

#Loop the impact of different artifact distributions on surveys
distr.loop<-surveyLoops(
               parametersExample,
               "obj.distribution",
               c("uniform","linear","spherical","sinusoidal"),
               "sitesFoundOnArtifacts")
}
}
