% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummaryPlot.R
\name{plotSurveySumm}
\alias{plotSurveySumm}
\title{Plot Survey Summaries}
\usage{
plotSurveySumm(summaryList, plot = "sites.found", labels = NULL)
}
\arguments{
\item{summaryList}{a list of survey summaries, the output of \code{surveySim()}}

\item{plot}{what variable to plot. Options are:\itemize{
\item \code{sites.found} - plots frequency of sites found
\item \code{survey.hits} - plots frequency of surveys that hit a site
\item \code{success.rate.index} - plots the success rate of surveys, i.e. the ratio of successful surveys over total surveys
\item \code{sites.found.arti} - plots frequency of sites found \strong{based on artifacts present in sites}
\item \code{survey.hits.arti} - plots frequency of surveys that found \strong{at least one artifact}
}}

\item{labels}{vector with name of each item in list, to be added to the legend. If \code{NULL}, names will be taken from list}
}
\description{
Plots the different results from \code{surveySim()}
}
\details{
This function will plot the results of the \code{surveySim()} simulations using Kernel Density plots.
All the grids that are to be compared should be grouped into 1 list (list(a,b,c,etc...))
The plot function allows you to choose different parts of the survey summaries produced by \code{surveySim()} you want to plot.
}
\examples{
 \donttest{
 #create 3 Simulations with sites of different sizes:
 small.sites<-parametersExample
 small.sites$site.area=500

 medium.sites<-parametersExample
 medium.sites$site.area=1000

 large.sites<-parametersExample
 large.sites$site.area=2000

 #run the 3 simulations
 small.survey<-surveySim(small.sites)
 medium.survey<-surveySim(medium.sites)
 large.survey<-surveySim(large.sites)

 #create the comparative plot.
 #note that the results go into a list. If labels are not given, legend is built on list names
 plotSurveySumm(
       list(small.survey,medium.survey,large.survey),
       plot="sites.found",
       labels=c("Small sites","Medium sites","Large sites"))
}

}
