% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtPars.R
\name{Extract3PLMirt}
\alias{Extract3PLMirt}
\title{Extract item discrimination, difficulties, and guessing parameters and estimate covariance estimates for 3PL items from a fitted mirt object
for one or two groups}
\usage{
Extract3PLMirt(mod, focal = NULL, reference = NULL)
}
\arguments{
\item{mod}{A mirt object containing the fit of unidimensional model.}

\item{focal}{Character. Required if mod is MultipleGroupClass, focal should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}

\item{reference}{Character. Required if mod is MultipleGroupClass, reference should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}
}
\value{
If mod contains any itemtype == "3PL", a list with the item parameters and the estimate covariances (if available).
If mod is SingleGroupClass, the list contains the item parameters as a matrix and the covariances as a list.
If mod is MultipleGroupClass, the list contains the item parameters and covariances for the focal and reference groups only.
}
\description{
Extract item discrimination, difficulties, and guessing parameters and estimate covariance estimates for 3PL items from a fitted mirt object
for one or two groups
}
\examples{
library(mirt)
data <- expand.table(LSAT7)
(mod1 <- mirt(data, model = 1, itemtype = "3PL", SE = TRUE))
(DFIT:::Extract3PLMirt(mod1))

}
