% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirtPars.R
\name{Extract2PLMirt}
\alias{Extract2PLMirt}
\title{Extract item discrimination and difficulties and estimate covariance estimates for 2PL items from a fitted mirt object
for one or two groups}
\usage{
Extract2PLMirt(mod, focal = NULL, reference = NULL)
}
\arguments{
\item{mod}{A mirt object containing the fit of unidimensional model.}

\item{focal}{Character. Required if mod is MultipleGroupClass, focal should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}

\item{reference}{Character. Required if mod is MultipleGroupClass, reference should coincide with the label for the focal group. If mod is SingleGroupClass, it is ignored.}
}
\value{
If mod contains any itemtype == "2PL", a list with the item parameters and the estimate covariances (if available).
If mod is SingleGroupClass, the list contains the item parameters as a matrix and the covariances as a list.
If mod is MultipleGroupClass, the list contains the item parameters and covariances for the focal and reference groups only.
}
\description{
Extract item discrimination and difficulties and estimate covariance estimates for 2PL items from a fitted mirt object
for one or two groups
}
\examples{
library(mirt)
data <- expand.table(LSAT7)
(mod1 <- mirt(data, model = 1, itemtype = "2PL", SE = TRUE))
(DFIT:::Extract2PLMirt(mod1))

}
