% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_meta_data.R
\name{table_info}
\alias{table_info}
\title{Define Metadata for a Data Table in a Tidy data.table}
\usage{
table_info(
  table_name,
  source_identifier,
  identifier_columns,
  key_outcome_specs
)
}
\arguments{
\item{table_name}{Character string, the conceptual name of the table.}

\item{source_identifier}{Character string, the file name or DB table identifier.}

\item{identifier_columns}{Character vector, names of column(s) acting as primary key(s).}

\item{key_outcome_specs}{A list of 'OutcomeSpec' lists.}
}
\value{
A tidy data.table with the table's metadata. The \code{identifier_columns} and
\code{grouping_variables} columns are list-columns.
}
\description{
Takes descriptive information about a table and returns a tidy data.table.
}
\examples{
transactions_info <- table_info(
  table_name = "transactions",
  source_identifier = "transactions.csv",
  identifier_columns = c("customer_id", "product_id", "time"),
  key_outcome_specs = list(
    list(
      OutcomeName = "Revenue",
      ValueExpression = quote(price * quantity),
      AggregationMethods = list(
        list(AggregatedName = "RevenueByCustomer", AggregationFunction = "sum",
             GroupingVariables = "customer_id"),
        list(AggregatedName = "RevenueByProduct", AggregationFunction = "sum",
             GroupingVariables = "product_id")
      )
    )
  )
)
# Note the structure of the list-columns
print(transactions_info)
str(transactions_info[, .(identifier_columns, grouping_variable)])

}
