% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H_CombineReduceTaxaOutput.R
\name{combine_reduced_output}
\alias{combine_reduced_output}
\title{Combine Reduce Taxa Files for the Same Biological Samples using Different Markers}
\usage{
combine_reduced_output(fileLoc = NULL, presenceAbsence = TRUE, verbose = TRUE)
}
\arguments{
\item{fileLoc}{The location of a file in a directory where all of the 'taxa_assign'
and/or 'combined_taxa_assign' files are located (Default NULL).}

\item{presenceAbsence}{This setting is a TRUE or FASLE value that indicates
if the results will include read counts or be reduced to 0/1 presence absence values
(Default TRUE)}

\item{verbose}{If set to TRUE then there will be output to the R console, if
FALSE then this reporting data is suppressed (Default TRUE).}
}
\value{
This function produces a single 'YYYY_MM_DD_HHMM_CombineTaxaReduced' file and
associated summary file in the target directory.
}
\description{
This function takes a file selection and then uses all 'taxaReduced' files
in that directory and combines them into a single taxa table file with presence
absence results.The output file is named with the string _CombineTaxaReduced.tsv
}
\details{
The User Input: This function requires a file in a directory where all 'taxaReduced'
files in that directory will be combined. The output format will be a taxa table
with all taxa from all files combined into a single table with presence absence
(0 or 1) results. The value metrics for the identification of the taxa from each
combined file will remain in a column with the parenthetical results from the 'taxaReduced'
files ("Num_Rec", "Coverage", "Identity", "Max_eVal").

The examples are present to display the syntax for the function.
These examples are not run because there are files required to run the functions,
in some cases multiple files are necessary and some of these are quite large. To
get specific examples please see https://github.com/rgyoung6/DBTCShinyTutorial/blob/main/README.md
}
\note{
WARNING - NO WHITESPACE!

When running DBTC functions the paths for the files selected cannot have white
space! File folder locations should be as short as possible (close to the root
as some functions do not process long naming conventions.

Also, special characters should be avoided (including question mark, number
sign, exclamation mark). It is recommended that dashes be used for separations
in naming conventions while retaining underscores for use as information
delimiters (this is how DBTC functions use underscore).

There are several key character strings used in the DBTC pipeline, the presence
of these strings in file or folder names will cause errors when running DBTC functions.

The following strings are those used in DBTC and should not be used in file or folder naming:
- _BLAST
- _combinedDada
- _taxaAssign
- _taxaAssignCombined
- _taxaReduced
- _CombineTaxaReduced
}
\examples{
\dontrun{
combine_reduced_output()
combine_reduced_output(fileLoc = NULL, presenceAbsence = TRUE)
}

}
\references{
<https://github.com/rgyoung6/DBTC>
Young, R. G., Hanner, R. H. (Submitted October 2023). Dada-BLAST-Taxon Assign-Condense
Shiny Application (DBTCShiny). Biodiversity Data Journal.
}
\seealso{
dada_implement()
combine_dada_output()
make_BLAST_DB()
seq_BLAST()
taxon_assign()
combine_assign_output()
reduce_taxa()
}
\author{
Robert G. Young
}
