% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printD3mirt.R
\name{print.D3mirt}
\alias{print.D3mirt}
\title{Print Method for S3 Objects of Class \code{D3mirt}}
\usage{
\method{print}{D3mirt}(x, ...)
}
\arguments{
\item{x}{A S3 object of class \code{D3mirt}.}

\item{...}{Additional arguments.}
}
\value{
A printed message reporting the number of items, levels of difficulty, the number of construct vectors, and the names of the respective items contained in each construct.
}
\description{
The print method for the \code{\link[=D3mirt]{D3mirt()}} function.
}
\examples{
\dontrun{
# Load data
data("anes0809offwaves")
x <- anes0809offwaves
x <- x[, 3:22] # Remove columns for age and gender

# Call D3mirt()
mod <- D3mirt(x, modid = c("W7Q3", "W7Q20"))

# Print model summary
print(mod)
}
}
\author{
Erik Forsberg
}
