% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peacoqc.R
\name{peacoqc}
\alias{peacoqc}
\alias{peacoqc.copy_settings,UserSession,PeacoQC-method}
\alias{peacoqc.copy_settings}
\alias{peacoqc.list,UserSession-method}
\alias{peacoqc.list}
\alias{peacoqc.new,UserSession-method}
\alias{peacoqc.new}
\alias{peacoqc.rename,UserSession,PeacoQC-method}
\alias{peacoqc.rename}
\alias{peacoqc.run,UserSession,PeacoQC-method}
\alias{peacoqc.run}
\alias{peacoqc.show,UserSession-method}
\alias{peacoqc.show}
\alias{peacoqc.status,UserSession,PeacoQC-method}
\alias{peacoqc.status}
\alias{peacoqc.update,UserSession,PeacoQC-method}
\alias{peacoqc.update}
\title{PeacoQC Endpoints}
\usage{
\S4method{peacoqc.copy_settings}{UserSession,PeacoQC}(
  UserSession,
  peacoqc,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{peacoqc.list}{UserSession}(
  UserSession,
  experiment_id,
  output = "default",
  timeout = UserSession@short_timeout
)

\S4method{peacoqc.new}{UserSession}(
  UserSession,
  experiment_id,
  peaco_qc_name,
  timeout = UserSession@long_timeout
)

\S4method{peacoqc.rename}{UserSession,PeacoQC}(
  UserSession,
  peacoqc,
  peaco_qc_name,
  timeout = UserSession@short_timeout
)

\S4method{peacoqc.run}{UserSession,PeacoQC}(
  UserSession,
  peacoqc,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{peacoqc.show}{UserSession}(
  UserSession,
  experiment_id,
  peaco_qc_id,
  timeout = UserSession@short_timeout
)

\S4method{peacoqc.status}{UserSession,PeacoQC}(
  UserSession,
  peacoqc,
  output = "default",
  timeout = UserSession@long_timeout
)

\S4method{peacoqc.update}{UserSession,PeacoQC}(UserSession, peacoqc, timeout = UserSession@long_timeout)
}
\arguments{
\item{UserSession}{Cytobank UserSession object}

\item{peacoqc}{Cytobank PeacoQC object}

\item{output}{character representing the output format  \strong{[optional]}\cr
\emph{- peacoqc.list, peacoqc.run, peacoqc.status, peacoqc.copy_settings : \code{("default", "raw")}}}

\item{timeout}{integer representing the request timeout time in seconds  \strong{[optional]}}

\item{experiment_id}{integer representing an \link[=experiments]{experiment} ID}

\item{peaco_qc_name}{character representing a new PeacoQC name}

\item{peaco_qc_id}{integer representing a PeacoQC ID}
}
\description{
Interact with PeacoQC using these endpoints.
}
\details{
\code{peacoqc.copy_settings} Copy PeacoQC settings from an experiment and returns a PeacoQC object.

\code{peacoqc.list} List all PeacoQC from an experiment. Outputs a dataframe [default] or list with all fields present.\cr
\emph{- Optional output parameter, specify one of the following: \code{("default", "raw")}}

\code{peacoqc.new} Create a new PeacoQC advanced analysis from an experiment and returns a PeacoQC object.

\code{peacoqc.rename} Rename a PeacoQC from an experiment and returns a PeacoQC object.

\code{peacoqc.run} Run a PeacoQC from an experiment.

\code{peacoqc.show} Show PeacoQC details from an experiment and returns a PeacoQC object.

\code{peacoqc.status} Show the status of a PeacoQC from an experiment.

\code{peacoqc.update} Update a PeacoQC from an experiment and returns the new PeacoQC object.
}
\examples{
\dontrun{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")

# cyto_peacoqc refers to a PeacoQC object that is created from PeacoQC endpoints
#   examples: peacoqc.new, peacoqc.show (see details section for more)
}
\dontrun{peacoqc.copy_settings(cyto_session, peacoqc=cyto_peacoqc)
}
\dontrun{# Dataframe of all PeacoQCs with all fields present
peacoqc.list(cyto_session, 22)

# Raw list of all PeacoQCs with all fields present
peacoqc.list(cyto_session, 22, output="raw")
}
\dontrun{peacoqc.new(cyto_session, 22, peaco_qc_name="My new PeacoQC")
}
\dontrun{peacoqc.rename(cyto_session, peacoqc=cyto_peacoqc,
    peaco_qc_name="My updated PeacoQC name")
}
\dontrun{peacoqc.run(cyto_session, peacoqc=cyto_peacoqc)
}
\dontrun{peacoqc.show(cyto_session, experiment_id=22, peaco_qc_id=2)
}
\dontrun{peacoqc.status(cyto_session, peacoqc=cyto_peacoqc)
}
\dontrun{peacoqc.update(cyto_session, peacoqc=cyto_peacoqc)
}
}
