% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5Access.R
\name{readH5ADUnsSpMat}
\alias{readH5ADUnsSpMat}
\title{Extract a sparse matrix from adata.uns stored in an H5AD file}
\usage{
readH5ADUnsSpMat(filename, unsKey)
}
\arguments{
\item{filename}{File path to the H5AD file.}

\item{unsKey}{The \code{adata.uns} key to extract, must use only one
character string.}
}
\value{
A CSC-matrix of "dgCMatrix" class
}
\description{
Primarily designed for fetching the velocity data presented as a cell-cell
transition graph.
}
\examples{
\dontrun{
h5adFile <- "path/to/analysis.h5ad"
velo <- readH5ADUnsSpMat(h5adFile, "velo_s_norm_graph")
}
}
\seealso{
Other H5AD-reader: 
\code{\link{readH5ADObsNames}()},
\code{\link{readH5ADObsVar}()},
\code{\link{readVelocytoLoom}()}
}
\concept{H5AD-reader}
