% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdf5Access.R
\name{readH5ADObsNames}
\alias{readH5ADObsNames}
\title{Extract `adata.obs_names` from an H5AD file}
\usage{
readH5ADObsNames(filename)
}
\arguments{
\item{filename}{File path to the H5AD file.}
}
\value{
A character vector of cell IDs.
}
\description{
It frequently happens that velocity analyses stored in H5AD files do not
contain the full raw count data suggested for CytoSimplex visualization.
Extracting the cell IDs (e.g. barcodes) helps matching the velocity data to
raw count data imported from other sources.
}
\examples{
\dontrun{
h5adFile <- "path/to/analysis.h5ad"
cellIDs <- readH5ADObsNames(h5adFile)
}
}
\seealso{
Other H5AD-reader: 
\code{\link{readH5ADObsVar}()},
\code{\link{readH5ADUnsSpMat}()},
\code{\link{readVelocytoLoom}()}
}
\concept{H5AD-reader}
