% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_ttest.R
\name{cyt_ttest}
\alias{cyt_ttest}
\title{Two Sample T-test Comparisons. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
\usage{
cyt_ttest(data, scale = NULL, verbose = TRUE, format_output = FALSE)
}
\arguments{
\item{data}{A matrix or data frame containing continuous and categorical variables.}

\item{scale}{A character specifying a transformation for continuous variables.
Options are \code{NULL} (default) and \code{"log2"}. When \code{scale = "log2"},
a log2 transformation is applied and a two-sample t-test is used; when \code{scale} is \code{NULL},
a Mann-Whitney U test is performed.}

\item{verbose}{A logical indicating whether to print the p-values of the statistical tests.
Default is \code{TRUE}.}

\item{format_output}{Logical. If TRUE, returns the results as a tidy data frame.
Default is \code{FALSE}.}
}
\value{
If \code{format_output} is FALSE, returns a list of p-values (named by Outcome and Categorical variable).
If TRUE, returns a data frame in a tidy format.
}
\description{
This function performs pairwise comparisons between two groups for each combination
of a categorical predictor (with exactly two levels) and a continuous outcome variable.
It first converts any character variables in \code{data} to factors and, if specified,
applies a log2 transformation to the continuous variables. Depending on the value of
\code{scale}, the function conducts either a two-sample t-test (if \code{scale = "log2"})
or a Mann-Whitney U test (if \code{scale} is \code{NULL}). The resulting p-values are printed
and returned.
}
\examples{
data_df <- ExampleData1[, -c(3)]
data_df <- dplyr::filter(data_df, Group != "ND", Treatment != "Unstimulated")
# Test example
cyt_ttest(
 data_df[, c(1:2, 5:6)],
 scale = "log2",
 verbose = TRUE,
 format_output = TRUE
)
}
\author{
Shubh Saraswat
}
