% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyt_export.R
\name{cyt_export}
\alias{cyt_export}
\title{Generic export function for Cytokine plots}
\usage{
cyt_export(
  plots,
  filename = "cyto_output",
  format = c("pdf", "png", "jpeg", "tiff", "svg"),
  width = 7,
  height = 5,
  dpi = 300,
  which = NULL
)
}
\arguments{
\item{plots}{A single plot object or a list of plots.  Each
element may be a \code{ggplot}/grid object, a \code{recordedplot}, or a
function with no arguments that when invoked produces the plot.}

\item{filename}{Base file name (without extension).  The
appropriate extension is added automatically depending on
\code{format}.  A full path can be supplied to save into a
particular directory.  When saving raster formats the file
names will include an index (e.g. \code{"myplot_001.png"}).}

\item{format}{Character string giving the desired output format.
One of "pdf", "png", "jpeg" or "tiff".  Partial matching is
performed.  The default is "pdf".}

\item{width, height}{Width and height of the device in inches.
These arguments are passed directly to the graphics device.}

\item{dpi}{Resolution in dots per inch used for raster formats
(ignored for PDF).}

\item{which}{Optional character vector naming the subset of
\code{plots} to save.  If provided, only the named plots are
exported; otherwise all elements are saved in the order they
appear.}
}
\description{
The purpose of this helper is to save a collection of plots
generated throughout the CytoProfile package to a user specified
format.  It is designed to handle objects created with \code{ggplot2}
(or other grid based plots), recorded base plots (see
\code{grDevices::recordPlot()}), or custom drawing functions stored
as closures.  If a multi-page PDF is requested, all plots are
written into a single file; for raster formats (PNG, JPEG and
TIFF), each element of the plot list is saved to its own file
with a numbered suffix.  Nothing is returned except invisibly.
}
\examples{
# Example usage within CytoProfile:
# res <- cyt_splsda(...)
# cyt_export(res$plots, filename = "splsda", format = "png")

}
