% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_las_objects.R
\name{las_merge}
\alias{las_merge}
\title{Makes one las-object from multiple las-objects}
\usage{
las_merge(..., oci = FALSE, fill = FALSE)
}
\arguments{
\item{...}{any number of las objects or a list with las objects}

\item{oci}{add a column with the original cloud index}

\item{fill}{fill missing columns with NA if it is set to False columns which do not exist in all las-objects will be removed}
}
\value{
A single las-object with only the overlapping column name
}
\description{
This function merges multiple las objects into one las object. The function checks if all inputs are las-objects and if they have the same CRS. The function will also add a column oci with the original cloud index to each las-object. The function will then rbind all data by the minimum set of columns. If the fill argument is set to False, columns which do not exist in all las objects will be removed. If the fill argument is set to True, missing columns will be filled with NA.
}
\examples{
# number of points per las
n <- 100
las1 <- lidR::LAS(data.frame(X = runif(n), Y = runif(n), Z = runif(n)))
las2 <- lidR::LAS(data.frame(X = runif(n) + 2, Y = runif(n), Z = runif(n)))
las3 <- lidR::LAS(data.frame(X = runif(n) + 4, Y = runif(n), Z = runif(n)))
merged <- las_merge(las1, las2, las3)
lidR::npoints(merged) == (n*3)

lasList <- list(las1,las2,las3)
merged <- las_merge(lasList)
lidR::npoints(merged) == (n*3)

}
