% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cum_normal_density.R
\name{cum_normal_density}
\alias{cum_normal_density}
\title{Cumulative Normal Distribution Function}
\usage{
cum_normal_density(x)
}
\arguments{
\item{x}{A numeric value or vector for which the cumulative normal distribution 
is to be calculated.}
}
\value{
Returns the cumulative probability under the normal curve from \(-\deqn{\infty}{infinity}\) to x.
}
\description{
This function calculates the cumulative normal distribution function (CDF) 
for a given value x using the Hastings approximation method. This approximation 
is typically used in finance for the calculation of option pricing probabilities.
}
\details{
The function uses a polynomial approximation as described by E.G. Haug in 
"The Complete Guide to Option Pricing Formulas" to estimate the CDF of a normal distribution.
The coefficients used in the approximation are specifically chosen to minimize the error
in the tail of the distribution, which is critical for financial applications like option pricing.

The polynomial approximation is applied to the normal density function:
\deqn{N(x) = \frac{1}{\sqrt{2\pi}} e^{-x^2/2}}

Then, the cumulative probability is adjusted based on the sign of x:
- If x is non-negative, it returns \(1 - t\), where t is the polynomial approximation.
- If x is negative, it returns \(t\).

The cumulative normal distribution function is important in statistics for hypothesis
testing and in finance for the Black-Scholes option pricing formula.
}
\examples{
cum_normal_density(1.96)  
cum_normal_density(-1.96) 

}
\references{
Haug, E.G., The Complete Guide to Option Pricing Formulas.
Hastings, C. Approximations for Digital Computers. Princeton Univ. Press, 1955.
}
