% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovEst.hardPD.R
\name{CovEst.hardPD}
\alias{CovEst.hardPD}
\title{Covariance Estimation via Hard Thresholding under Positive-Definiteness Constraint}
\usage{
CovEst.hardPD(X)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix where each row is an observation.}
}
\value{
a named list containing: \describe{
\item{S}{a \eqn{(p\times p)} covariance matrix estimate.}
\item{optC}{an optimal threshold value \eqn{C_{min}} that guarantees positive definiteness after thresholding.}
}
}
\description{
Sparse covariance estimation does not necessarily guarantee positive definiteness of an estimated
covariance matrix. Fan et al. (2013) proposed to solve this issue by taking an iterative procedure to
take an incremental decrease of threshold value until positive definiteness is preserved.
}
\examples{
## generate data from multivariate normal with Identity covariance.
pdim <- 5
data <- matrix(rnorm(10*pdim), ncol=pdim)

## apply 4 different schemes
out1 <- CovEst.hard(data, thr=0.1)  # threshold value 0.1
out2 <- CovEst.hard(data, thr=1)    # threshold value 1
out3 <- CovEst.hard(data, thr=10)   # threshold value 10
out4 <- CovEst.hardPD(data) # automatic threshold checking

## visualize 4 estimated matrices
mmessage <- paste("hardPD::optimal thr=",sprintf("\%.2f",out4$optC),sep="")
gcol     <- gray((0:100)/100)
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,2), pty="s")
image(out1$S[,pdim:1], col=gcol, main="thr=0.1")
image(out2$S[,pdim:1], col=gcol, main="thr=1")
image(out3$S[,pdim:1], col=gcol, main="thr=10")
image(out4$S[,pdim:1], col=gcol, main=mmessage)
par(opar)

}
\references{
\insertRef{fan_large_2013}{CovTools}
}
