% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.mzData.R
\docType{class}
\name{read.mzData}
\alias{read.mzData}
\alias{xcmsRawLike-class}
\title{read.mzData.}
\usage{
read.mzData(filename, fmt = c("xcmsRaw", "xcmsRawLike"), verbose = FALSE)
}
\arguments{
\item{filename}{A path to a mzData file (as exported by `xcms::write.mzdata()`).}

\item{fmt}{Output format. Currently `xcmsRaw` and `xcmsRawLike` are supported.
The latter is an S4 class similar to xcmsRaw but allowing to omit the xcms
package.}

\item{verbose}{Print messages to console.}
}
\value{
A generic R object of class xcmsRaw.
}
\description{
\code{read.mzData} will import mzData as xcmsRaw-class objects.
}
\details{
The main task of read.mzData functions is to import mzData files to R. 
    Currently `xcmsRaw` is supported as an output format. I created this 
    function for legacy reasons as the mzData import is no longer supported 
    by `mzR` and consequently `xcms` since 09/2021.
    This is a quick and dirty implementation. It will work only for mslevel=1
    and a fixed set of base64 encoding parameters (size = 4, endian = "big").
    However, feel free to send me an e-mail if you are interested in using
    the function but cant get it working.
}
\examples{
\dontrun{
  data(mzXML_data)
  write.mzXML(mzXML = mzXML_data, filename = "test.mzXML")
  x <- xcms::xcmsRaw("test.mzXML",  profstep=0)
  xcms::write.mzdata(x, file="test.mzData")
  x2 <- read.mzData(filename = "test.mzData")
  identical(str(x), str(x2))
  identical(x@env$intensity, x2@env$intensity)
  identical(x@env$mz, x2@env$mz)
  identical(x@scanindex, x2@scanindex)
  file.remove(c('test.mzData', 'test.mzXML'))
  
  # check that objects are independent (not identical)
  identical(methods::new("xcmsRawLike"), methods::new("xcmsRawLike"))
} 

}
