% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreConcept.R
\name{drawCore}
\alias{drawCore}
\title{Draw core for 3 or 4 players}
\usage{
drawCore(v, holdOn = FALSE, colour = "red", label = FALSE, name = "Core")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawCore draws the core for 3 or 4 players.
}
\examples{
library(CoopGame)
v <- c(0,0,0,3,3,3,6)
drawCore(v)

}
\references{
Gillies D.B. (1953)  \emph{Some Theorems on n-person Games}, Ph.D. Thesis, Princeton University Press.

Aumann R.J. (1961) "The core of a cooperative game without side payments", Transactions of the American Mathematical Society 98(3), pp. 539--552

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, pp. 27--49

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 686--747

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, pp. 257--275
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
