% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ConsReg}
\alias{predict.ConsReg}
\title{Predict or fitted values of object \code{ConsReg}}
\usage{
\method{predict}{ConsReg}(object, newdata = NULL, components = F, ...)
}
\arguments{
\item{object}{object of class \code{ConsReg}}

\item{newdata}{New data to predict the objective function. If is NULL (default),
then the fitted values will be returned}

\item{components}{if its \code{TRUE}, it will return the predictions for each regression component}

\item{...}{Additional argument passed to family. In particular, at this moment,
if type = 'link', then for binomial family, it will return the link values}
}
\value{
predictions
}
\description{
Predict or fitted values of object \code{ConsReg}
}
\examples{
data('fake_data')
data = fake_data
data$y = 1/(1+exp(-data$y))
data$y = ifelse(data$y > .5, 1, 0)
table(data$y)

fit5 = ConsReg(y~x1+x2+x3+x4, data = data,
               family = 'binomial', penalty = 10000,
               LOWER = -.5, UPPER = .2,
               optimizer = 'gosolnp')
pr = predict(fit5, newdata = data[1:3,], type = 'probability')
pr

}
