% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{Eta_squared}
\alias{Eta_squared}
\title{Eta Squared Statistic for Strength of Association}
\usage{
Eta_squared(a, b)
}
\arguments{
\item{a}{A numeric vector representing the dependent variable.}

\item{b}{A categorical or numeric vector representing the grouping variable.}
}
\value{
A numeric value between 0 and 1 representing the Eta squared statistic.
}
\description{
Computes the Eta squared statistic to quantify the strength of association between a numeric variable and another numeric variable or a grouping factor.
}
\details{
This measure is based on variance decomposition without relying on linear model.
The second argument can be a categorical variable, which allows the function to handle both numeric and labelled inputs.
Variable \code{a} is treated as the response and inserted as rows in the contingency table,
while \code{b} can be treated as the grouping factor (columns).
The function is compatible with both raw (elementary) data and grouped frequency distributions.
}
\examples{
Eta_squared(c(1, 2.5, 4, 7, 7, 11), c("a", "b", "b", "c", "d", "f"))

}
