% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{Cramer_V}
\alias{Cramer_V}
\title{Cramer V Statistic for Strength of Association}
\usage{
Cramer_V(a, b)
}
\arguments{
\item{a}{A numeric or categorical vector (used for rows in the contingency table).}

\item{b}{A numeric or categorical vector (used for columns in the contingency table).}
}
\value{
A numeric value between 0 and 1 representing the strength of association (Cramer V).
}
\description{
Computes Cramer V to assess the strength of association between two categorical variables.
}
\details{
This measure is derived from the Chi-squared statistic and a contingency table.
Both parameters can be a categorical variable, allowing flexibility in working with labelled data.
Variable \code{a} is treated as rows and \code{b} as columns in the contingency table.
The function supports both elementary data records and grouped frequency distributions.
}
\examples{
Cramer_V(c(1, 1, 1, 4, 6), c("a", "b", "c", "c", "c"))

}
