% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity_estimation.distributions.R
\encoding{UTF-8}
\name{d.mix.dists.func}
\alias{d.mix.dists.func}
\title{Returns probability density function (PDF) for a mix of marked and unmarked 
individuals}
\usage{
d.mix.dists.func(d.unmarked, d.marked)
}
\arguments{
\item{d.unmarked}{A function representing the PDF of unmarked individuals. 
Must be normalized so that it integrates to 1 for the function to work 
properly.}

\item{d.marked}{A function representing the PDF of marked individuals.  Must 
be normalized so that it integrates to 1 for the function to work properly.}
}
\value{
A function representing the PDF of observations drawn from the mixed 
  distribution of marked and unmarked individuals.  The function takes two 
  arguments: \code{p.marked}, the fraction of marked individuals in the
  distribution; and \code{obs}, a vector of observed score values.
}
\description{
This function returns a probability density function (PDF) for scores for a 
mix of marked and unmarked individuals with known fraction of marked 
individuals. The distributions for marked individuals and for unmarked 
individuals must be known.
}
\references{
Kaplan DM, Cuif M, Fauvelot C, Vigliola L, Nguyen-Huu T, Tiavouane J and Lett C 
  (in press) Uncertainty in empirical estimates of marine larval connectivity. 
  ICES Journal of Marine Science. doi:10.1093/icesjms/fsw182.
}
\seealso{
See also \code{\link{d.rel.conn.dists.func}},
  \code{\link{optim.rel.conn.dists}}.
}
\author{
David M. Kaplan \email{dmkaplan2000@gmail.com}
}
