[![Project Status: Inactive.](https://www.repostatus.org/badges/latest/inactive.svg)](https://www.repostatus.org/#inactive)
[![CRAN Status Badge](https://www.r-pkg.org/badges/version/CongreveLamsdell2016)](https://cran.r-project.org/package=CongreveLamsdell2016)
[![CRAN Downloads](https://cranlogs.r-pkg.org/badges/CongreveLamsdell2016)](https://cran.r-project.org/package=CongreveLamsdell2016)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.2536874.svg)](https://doi.org/10.5281/zenodo.2536874)



# CongreveLamsdell2016

This R package provides data and analyses that accompany the paper

- Smith, M. R. (2019), Bayesian and parsimony approaches reconstruct informative trees from simulated morphological datasets, _Biological Letters_, 15:20180632, 
doi:[10.1098/rsbl.2018.0632](https://doi.org/10.1098/rsbl.2018.0632).

It incorporates data from:

- Congreve, C. R., and J. C. Lamsdell. 2016. Implied weighting and its utility in palaeontological datasets: a study using modelled phylogenetic matrices. _Palaeontology_, 59:447–462. doi:[10.1111/pala.12236](https://dx.doi.org/10.1111/pala.12236).

- Congreve, C. R., and J. C. Lamsdell. 2016. Data from: Implied weighting and its utility in palaeontological datasets: a study using modelled phylogenetic matrices. _Dryad Digital Repository_, doi:[10.5061/dryad.7dq0j](https://dx.doi.org/10.5061/dryad.7dq0j).

Some of these data are used in the [`Quartet`](https://ms609.github.io/Quartet/) package.

Equivalent data and analyses from data simulated by O'Reilly _et al._ (2016) 
are available at [ms609.github.io/OReillyEtAl2016](https://ms609.github.io/OReillyEtAl2016/).

## Installation
## 
Install and load the library from CRAN as follows:

```
install.packages('CongreveLamsdell2016')
library('CongreveLamsdell2016')
```

<!--You can install the development version with:
`devtools::install_github('ms609/CongreveLamsdell2016')`.-->


## Documentation

The package includes documentation and visualizations of its results:

* R Package manual: [PDF](https://ms609.github.io/CongreveLamsdell2016/CongreveLamsdell2016_1.0.2.pdf)

* How to conduct the analyses:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Conduct-analyses.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Conduct-analyses.pdf)

* Node support comparisons:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Compare-node-supports.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Compare-node-supports.pdf)

* Comparisons of phylogenetic methods:
[HTML](https://ms609.github.io/CongreveLamsdell2016/Compare-methods.html) | 
[PDF](https://ms609.github.io/CongreveLamsdell2016/Compare-methods.pdf)
