% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvariantResidualDistributionTest.R
\name{InvariantResidualDistributionTest}
\alias{InvariantResidualDistributionTest}
\title{Invariant residual distribution test.}
\usage{
InvariantResidualDistributionTest(Y, E, X, alpha = 0.05,
  verbose = FALSE, fitWithGam = TRUE,
  test = leveneAndWilcoxResidualDistributions, colNameNoSmooth = NULL,
  mtry = sqrt(NCOL(X)), ntree = 100, nodesize = 5, maxnodes = NULL,
  returnModel = FALSE)
}
\arguments{
\item{Y}{An n-dimensional vector.}

\item{E}{An n-dimensional vector. E needs to be a factor.}

\item{X}{A matrix or dataframe with n rows and p columns.}

\item{alpha}{Significance level. Defaults to 0.05.}

\item{verbose}{If \code{TRUE}, intermediate output is provided. Defaults to \code{FALSE}.}

\item{fitWithGam}{If \code{TRUE}, a GAM is used for the nonlinear regression, else
a random forest is used. Defaults to \code{TRUE}.}

\item{test}{Unconditional independence test that tests whether residual distribution is
invariant across different levels of E. Defaults to \code{leveneAndWilcoxResidDistributions}.}

\item{colNameNoSmooth}{Gam parameter: Name of variables that should enter linearly into the model.
Defaults to \code{NULL}.}

\item{mtry}{Random forest parameter: Number of variables randomly sampled as
candidates at each split. Defaults to \code{sqrt(NCOL(X))}.}

\item{ntree}{Random forest parameter: Number of trees to grow. Defaults to 100.}

\item{nodesize}{Random forest parameter: Minimum size of terminal nodes. Defaults to 5.}

\item{maxnodes}{Random forest parameter: Maximum number of terminal nodes trees in the forest can have.
Defaults to \code{NULL}.}

\item{returnModel}{If \code{TRUE}, the fitted quantile regression forest model
will be returned. Defaults to \code{FALSE}.}
}
\value{
A list with the following entries:
\itemize{
 \item \code{pvalue} The p-value for the null hypothesis that Y and E are independent given X.
 \item \code{model} The fitted model if \code{returnModel = TRUE}.
 }
}
\description{
Tests the null hypothesis that Y and E are independent given X.
}
\examples{

# Example 1
n <- 1000
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * (X)^2 + rnorm(n)
InvariantResidualDistributionTest(Y, as.factor(E), X)
InvariantResidualDistributionTest(Y, as.factor(E), X, test = ksResidualDistributions)

# Example 2
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * E + rnorm(n)
InvariantResidualDistributionTest(Y, as.factor(E), X)
InvariantResidualDistributionTest(Y, as.factor(E), X, test = ksResidualDistributions)
}
