% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpA.kendallReg.R
\name{simpA.kendallReg}
\alias{simpA.kendallReg}
\alias{se.simpA_kendallReg_test}
\alias{coef.simpA_kendallReg_test}
\alias{vcov.simpA_kendallReg_test}
\alias{print.simpA_kendallReg_test}
\alias{plot.simpA_kendallReg_test}
\title{Test of the simplifying assumption using the constancy
of conditional Kendall's tau}
\usage{
simpA.kendallReg(
  X1,
  X2,
  Z,
  vectorZToEstimate = NULL,
  listPhi = list(z = function(z) {
     return(z)
 }),
  typeEstCKT = 4,
  h_kernel,
  Lambda = function(x) {
     return(x)
 },
  Lambda_deriv = function(x) {
     return(1)
 },
  Lambda_inv = function(x) {
     return(x)
 },
  lambda = NULL,
  h_lambda = h_kernel,
  Kfolds_lambda = 5,
  l_norm = 1
)

\method{se}{simpA_kendallReg_test}(object, type, ...)

\method{coef}{simpA_kendallReg_test}(object, ...)

\method{vcov}{simpA_kendallReg_test}(object, ...)

\method{print}{simpA_kendallReg_test}(x, ...)

\method{plot}{simpA_kendallReg_test}(x, ylim = c(-1.5, 1.5), ...)
}
\arguments{
\item{X1}{vector of observations of the first conditioned variable}

\item{X2}{vector of observations of the second conditioned variable}

\item{Z}{vector of observations of the conditioning variable}

\item{vectorZToEstimate}{vector containing the points \eqn{Z'_i}
to be used at which the conditional Kendall's tau should be estimated.}

\item{listPhi}{the list of transformations \eqn{phi} to be used.}

\item{typeEstCKT}{the type of estimation of the kernel-based estimation
of conditional Kendall's tau.}

\item{h_kernel}{the bandwidth used for the kernel-based estimations.}

\item{Lambda}{the function to be applied on conditional Kendall's tau.
By default, the identity function is used.}

\item{Lambda_deriv}{the derivative of the function \code{Lambda}.}

\item{Lambda_inv}{the inverse function of \code{Lambda}.}

\item{lambda}{the penalization parameter used for Kendall's regression.
By default, cross-validation is used to find the best value of \code{lambda}
if \code{length(listPhi) > 1}. Otherwise \code{lambda = 0} is used.}

\item{h_lambda}{bandwidth used for the smooth cross-validation
in order to get a value for \code{lambda}.}

\item{Kfolds_lambda}{the number of subsets used for the cross-validation
in order to get a value for \code{lambda}.}

\item{l_norm}{type of norm used for selection of the optimal lambda
by cross-validation. \code{l_norm=1} corresponds to the sum of
absolute values of differences between predicted and estimated
conditional Kendall's tau while \code{l_norm=2} corresponds to
the sum of squares of differences.}

\item{object, x}{an \code{S3} object of class \code{simpA_kendallReg_test}.}

\item{type}{type of standard error to be returned. Possible values are: \itemize{
  \item \code{"coefficients"}: standard errors for estimated coefficients
  \item \code{"kernel-based CKT"}: standard errors for the kernel-based
  estimated values of conditional Kendall's taus
  \item \code{"regression-based CKT"}: standard errors for the regression-based
  estimated values of conditional Kendall's taus
}}

\item{...}{other arguments, unused}

\item{ylim}{graphical parameter, see \link{plot}}
}
\value{
\code{simpA.kendallReg} returns an \code{S3} object of
class \code{simpA_kendallReg_test}, containing
\itemize{
    \item \code{statWn}: the value of the test statistic.
    \item \code{p_val}: the p-value of the test.
}

\code{plot.simpA_kendallReg_test} returns (invisibly) a matrix with columns
\code{z}, \code{est_CKT_NP}, \code{asympt_se_np}, \code{est_CKT_NP_q025},
\code{est_CKT_NP_q975}, \code{est_CKT_reg}, \code{asympt_se_reg},
\code{est_CKT_reg_q025}, \code{est_CKT_reg_q975}.
The first column correspond to the grid of values of z. The next 4 columns
are the NP (kernel-based) estimator of conditional Kendall's tau, with its
standard error, and lower/upper confidence bands. The last 4 columns are the
equivalents for the estimator based on Kendall's regression.

\code{plot.simpA_kendallReg_test} plots the kernel-based estimator and its
confidence band (in red), and the estimator based on Kendall's regression
and its confidence band (in blue).

Usually the confidence band for Kendall's regression is much tighter than the
pure non-parametric counterpart. This is because the parametric model is
sparser and the corresponding estimator converges faster (even without
penalization).

\code{print.simpA_kendallReg_test} has no return values and is only called
for its side effects.

Function \code{coef.simpA_kendallReg_test} returns the matrix of coefficients
with standard errors, z values and p-values.

Function \code{vcov.simpA_kendallReg_test} returns the (estimated)
variance-covariance matrix of the estimated coefficients.

Function \code{se.simpA_kendallReg_test} returns the standard errors of the
estimated coefficients or of the estimated conditional Kendall's taus.
}
\description{
This function computes Kendall's regression, a regression-like
model for conditional Kendall's tau. More precisely, it fits the model
\deqn{\Lambda(\tau_{X_1, X_2 | Z = z}) = \sum_{j=1}^{p'} \beta_j \psi_j(z),}
where \eqn{\tau_{X_1, X_2 | Z = z}} is the conditional Kendall's tau
between \eqn{X_1} and \eqn{X_2} conditionally to \eqn{Z=z},
\eqn{\Lambda} is a function from \eqn{]-1, 1]} to \eqn{R},
\eqn{(\beta_1, \dots, \beta_p)} are unknown coefficients to be estimated
and \eqn{\psi_1, \dots, \psi_{p'})} are a dictionary of functions.
Then, this function tests the assumption
\deqn{\beta_2 = \beta_3 = ... = \beta_{p'} = 0,}
where the coefficient corresponding to the intercept is removed.
}
\examples{

\donttest{
# We simulate from a non-simplified conditional copula
set.seed(1)
N = 300
Z = runif(n = N, min = 0, max = 1)
conditionalTau = -0.9 + 1.8 * Z
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

result = simpA.kendallReg(
  X1, X2, Z, h_kernel = 0.03,
  listPhi = list(z = function(z){return(z)} ) )
print(result)
plot(result)
# Obtain matrix of coefficients, std err, z values and p values
coef(result)
# Obtain variance-covariance matrix of the coefficients
vcov(result)
# Obtain standard errors of the kernel-based estimates of CKT
se(result, type = "kernel-based CKT")
# Obtain standard errors of the regression-based estimates of CKT
se(result, type = "regression-based CKT")

result_morePhi = simpA.kendallReg(
   X1, X2, Z, h_kernel = 0.03,
   listPhi = list(
     z = function(z){return(z)},
     cos10z = function(z){return(cos(10 * z))},
     sin10z = function(z){return(sin(10 * z))},
     `1(z <= 0.4)` = function(z){return(as.numeric(z <= 0.4))},
     `1(z <= 0.6)` = function(z){return(as.numeric(z <= 0.6))}) )
print(result_morePhi)
plot(result_morePhi)

# We simulate from a simplified conditional copula
set.seed(1)
N = 300
Z = runif(n = N, min = 0, max = 1)
conditionalTau = -0.3
simCopula = VineCopula::BiCopSim(N=N , family = 1,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

result = simpA.kendallReg(
   X1, X2, Z, h_kernel = 0.03,
   listPhi = list(
     z = function(z){return(z)},
     cos10z = function(z){return(cos(10 * z))},
     sin10z = function(z){return(sin(10 * z))},
     `1(z <= 0.4)` = function(z){return(as.numeric(z <= 0.4))},
     `1(z <= 0.6)` = function(z){return(as.numeric(z <= 0.6))}) )
print(result)
plot(result)
}

}
\references{
Derumigny, A., & Fermanian, J. D. (2020).
On Kendall’s regression.
Journal of Multivariate Analysis, 178, 104610.
(page 7)
\doi{10.1016/j.jmva.2020.104610}
}
\seealso{
The function to fit Kendall's regression:
\code{\link{CKT.kendallReg.fit}}.

Other tests of the simplifying assumption:
\itemize{
  \item \code{\link{simpA.NP}} in a nonparametric setting
  \item \code{\link{simpA.param}} in a (semi)parametric setting,
  where the conditional copula belongs to a parametric family,
  but the conditional margins are estimated arbitrarily through
  kernel smoothing

  \item the counterparts of these tests in the discrete conditioning setting:
  \code{\link{bCond.simpA.CKT}}
  (test based on conditional Kendall's tau)
  \code{\link{bCond.simpA.param}}
  (test assuming a parametric form for the conditional copula)
}
}
