% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bCond.simpA.param.R
\name{bCond.simpA.param}
\alias{bCond.simpA.param}
\title{Test of the assumption that a conditional copulas does not vary
through a list of discrete conditioning events}
\usage{
bCond.simpA.param(
  X1,
  X2,
  partition,
  family,
  testStat = "T2c_tau",
  typeBoot = "boot.NP",
  nBootstrap = 100
)
}
\arguments{
\item{X1}{vector of \code{n} observations of the first conditioned variable.}

\item{X2}{vector of \code{n} observations of the second conditioned variable.}

\item{partition}{matrix of size \code{n * p},
where \code{p} is the number of conditioning events that are considered.
partition[i,j] should be the indicator of whether the \code{i}-th observation
belongs or not to the \code{j}-th conditioning event.}

\item{family}{family of parametric copulas used}

\item{testStat}{test statistic used. Possible choices are
\itemize{
  \item \code{T2c_par} \eqn{\sum_{box} (\theta_0 - \theta(box))^2}
  \item \code{T2c_tau} Same as above, except that the copula family is now parametrized
  by its Kendall's tau instead of its natural parameter.
}}

\item{typeBoot}{type of bootstrap used}

\item{nBootstrap}{number of bootstrap replications}
}
\value{
a list containing
\itemize{
    \item \code{true_stat}:
    the value of the test statistic computed on the whole sample
    \item \code{vect_statB}:
    a vector of length \code{nBootstrap} containing the bootstrapped
    test statistics.
    \item \code{p_val}: the p-value of the test.
}
}
\description{
Test of the assumption that a conditional copulas does not vary
through a list of discrete conditioning events
}
\examples{
n = 50 # to get fast computation time. More realistic is n = 800.

Z = stats::runif(n = n)
CKT = 0.2 * as.numeric(Z <= 0.3) +
  0.5 * as.numeric(Z > 0.3 & Z <= 0.5) +
  + 0.3 * as.numeric(Z > 0.5)
family = 3
simCopula = VineCopula::BiCopSim(N = n,
  par = VineCopula::BiCopTau2Par(CKT, family = family), family = family)
X1 = simCopula[,1]
X2 = simCopula[,2]
partition = cbind(Z <= 0.3, Z > 0.3 & Z <= 0.5, Z > 0.5)

result = bCond.simpA.param(X1 = X1, X2 = X2, testStat = "T2c_tau",
  partition = partition, family = family, typeBoot = "boot.paramInd")
print(result$p_val)

n = 800
Z = stats::runif(n = n)
CKT = 0.1
family = 3
simCopula = VineCopula::BiCopSim(N = n,
  par = VineCopula::BiCopTau2Par(CKT, family = family), family = family)
X1 = simCopula[,1]
X2 = simCopula[,2]
partition = cbind(Z <= 0.3, Z > 0.3 & Z <= 0.5, Z > 0.5)

result = bCond.simpA.param(X1 = X1, X2 = X2,
  partition = partition, family = family, typeBoot = "boot.NP")
print(result$p_val)


}
\references{
Derumigny, A., & Fermanian, J. D. (2017).
About tests of the “simplifying” assumption for conditional copulas.
Dependence Modeling, 5(1), 154-197.
\doi{10.1515/demo-2017-0011}

Derumigny, A., & Fermanian, J. D. (2022)
Conditional empirical copula processes and generalized dependence measures
Electronic Journal of Statistics, 16(2), 5692-5719.
\doi{10.1214/22-EJS2075}
}
\seealso{
\code{\link{bCond.estParamCopula}} for the estimation
of a (conditional) parametric copula model in this framework.

\code{\link{bCond.simpA.CKT}} for a test of the simplifying assumption
that all these conditional copulas are equal,
based on the equality of conditional Kendall's tau
(i.e. without any parametric assumption).

Tests of the simplifying assumption for conditional copulas with a continuous
conditioning variable:
\itemize{
  \item \code{\link{simpA.NP}} in a nonparametric setting
  \item \code{\link{simpA.param}} in a (semi)parametric setting,
  where the conditional copula belongs to a parametric family,
  but the conditional margins are estimated arbitrarily through
  kernel smoothing
  \item \code{\link{simpA.kendallReg}}: test based on the constancy of
  conditional Kendall's tau
}
}
